<?php
include "inc/config.php";

// AMBIL DATA SEMUA HADIAH
$reward_list_html = "";
$q = $conn->query("SELECT * FROM rewards");
while($r = $q->fetch_assoc()) {
    $reward_list_html .= '
    <div class="col-md-4 text-center mb-4">
      <img src="'.$r['image_url'].'" class="img-fluid mb-2" style="max-height: 150px;">
      <h5>'.$r['name'].'</h5>
      <p>Chance: '.$r['chance'].'%</p>
    </div>';
}

// HANDLE VOUCHER SUBMIT
if(isset($_POST['voucher'])) {
    $code = $_POST['voucher'];

    $q = $conn->query("SELECT * FROM vouchers WHERE code='$code' AND (is_used=0 OR max_use > used_count)");

    if($q->num_rows == 0) {
        $error = "Voucher tidak valid atau sudah habis!";
    } else {
        $_SESSION['valid_voucher'] = $code;
        header("Location: index.php");
        exit;
    }
}

// HANDLE OPEN BOX
if(isset($_POST['open_box'])) {
    $voucher = $_SESSION['valid_voucher'];

    $rewards = $conn->query("SELECT * FROM rewards");
    $rewardArr = [];
    $totalChance = 0;
    while($r = $rewards->fetch_assoc()) {
        $rewardArr[] = $r;
        $totalChance += $r['chance'];
    }

    $roll = rand(1, $totalChance);
    $cumulative = 0;
    foreach($rewardArr as $rw) {
        $cumulative += $rw['chance'];
        if($roll <= $cumulative) {
            $reward = $rw;
            break;
        }
    }

    $conn->query("UPDATE vouchers SET used_count = used_count + 1, is_used = IF(used_count + 1 >= max_use, 1, 0) WHERE code='$voucher'");

    $conn->query("INSERT INTO history (voucher_code, reward_name, created_at) VALUES ('$voucher', '{$reward['name']}', NOW())");

    $_SESSION['reward_name'] = $reward['name'];
    $_SESSION['reward_image'] = $reward['image_url'];

    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Kotak Hadiah Lucky Box</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
     background: url('assets/bg-natal.jpg') no-repeat center center fixed;
     background-size: cover;
     min-height: 100vh;
     color: #fff;
     overflow-x: hidden;
    }

    .voucher-box {
      background-color: #111;
      border-radius: 10px;
      padding: 30px;
      max-width: 500px;
      margin: auto;
      margin-top: 40px;
      box-shadow: 0 0 30px gold;
    }
    .btn-gold {
      background-color: gold;
      color: #000;
      font-weight: bold;
    }
    .btn-gold:hover {
      background-color: #ffd700;
      color: #000;
    }
    .reward-popup img {
      max-width: 200px;
      margin-bottom: 20px;
    }
  </style>
  <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.9.3/dist/confetti.browser.min.js"></script>
</head>
<body class="text-center">

<!-- MODAL LIHAT HADIAH -->
<div class="modal fade" id="rewardsModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content bg-dark text-white">
      <div class="modal-header bg-warning text-dark">
        <h5 class="modal-title">🎁 Daftar Hadiah</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="row">
          <?= $reward_list_html ?>
        </div>
      </div>
    </div>
  </div>
</div>

<?php if(!isset($_SESSION['valid_voucher'])): ?>

  <!-- HEADER IMAGE -->
  <img src="assets/header-natal.png" class="img-fluid my-4" alt="Kotak Hadiah Lucky Box" style="max-width: 90%; height:auto;">

  <div class="voucher-box mb-3">
  <?php if(isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>

  <form method="POST" class="row g-2" id="voucherForm">
    <div class="col-8">
      <div class="input-group">
        <span class="input-group-text bg-warning text-dark">
          🎫
        </span>
        <input type="text" name="voucher" class="form-control" placeholder="Silahkan Isi Kode Voucher Anda" required>
      </div>
    </div>
    <div class="col-4">
      <button type="submit" class="btn btn-gold w-100">
        Submit 
      </button>
    </div>
  </form>
</div>

<div class="voucher-box">
  <button type="button" class="btn btn-gold w-100" data-bs-toggle="modal" data-bs-target="#rewardsModal">
    🎁 LIHAT HADIAH
  </button>
</div>


<?php elseif(isset($_SESSION['reward_name'])): ?>

  <script>
    confetti({
      particleCount: 200,
      spread: 90,
      origin: { y: 0.6 }
    });
  </script>

  <div class="container mt-5 reward-popup">
    <h3>🎉 Kamu menang:</h3>
    <img src="<?= $_SESSION['reward_image'] ?>" alt="reward" class="img-fluid">
    <h2 class="text-warning"><?= $_SESSION['reward_name'] ?> 🎁</h2>
    <form method="POST">
      <button class="btn btn-gold mt-3" name="reset">Main Lagi</button>
    </form>
  </div>

  <?php
  if(isset($_POST['reset'])) {
      unset($_SESSION['valid_voucher']);
      unset($_SESSION['reward_name']);
      unset($_SESSION['reward_image']);
      header("Location: index.php");
      exit;
  }
  ?>

<?php else: ?>

  <div class="container mt-5">
    <h3 class="mb-4 text-warning">Pilih salah satu box di bawah ini!</h3>
    <form method="POST">
      <div class="row justify-content-center">
        <?php for($i=1; $i<=12; $i++): ?>
          <div class="col-4 col-md-2 mb-3">
            <button type="submit" name="open_box" value="<?= $i ?>" class="btn btn-gold w-100 p-3">
              🎁
            </button>
          </div>
        <?php endfor; ?>
      </div>
    </form>
  </div>

<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
